-- Esse SQL tem o objetivo de trazer os dados de todos os colaboradores que apareceram no movimento do dia
IF EXISTS( SELECT 1 FROM sys.procedures WHERE name = 'p_plug_Farma_tipoRegistro_quatro' )
    BEGIN
        DROP PROCEDURE  p_plug_Farma_tipoRegistro_quatro;
    END;
GO

--p_plug_Farma_tipoRegistro_quatro 3,'20190319'

CREATE PROCEDURE p_plug_Farma_tipoRegistro_quatro (@filial INT , @data   DATE , @cd_emp INT  = 1)
AS
set nocount on;


SELECT
       4 AS tipoRegistro
     , ROW_NUMBER() OVER(ORDER BY colab.cd_fun ASC) AS numeroRegistro
     , colab.*
FROM
(
    SELECT DISTINCT
           FUNC.cd_fun
         , FUNC.cd_filial
         , FUNC.cpf_fun AS cpf
         , FUNC.rg_fun AS rg
         , FUNC.nm_fun AS nome
         , FUNC.dt_nasc AS dataNascimento
         , COALESCE(MUNICIPIO.cod_municipio_sintegra, 0) AS codigoIbgeCidade 
		 , FUNC.end_fun AS enderecoLogradouro
         , '' AS enderecoNumero
         , FUNC.bairro_fun AS enderecoComplemento
         , FUNC.cep AS cep
         , FUNC.tel_res AS telefone
         , FUNC.tel_cel AS celular
         , FUNC.email AS email
         , 1 AS cargo
    FROM
         pdv_vd VD
         INNER JOIN pdv_vd_it IT ON VD.cd_emp = IT.cd_emp
                                    AND VD.cd_filial = IT.cd_filial
                                    AND VD.cd_vd = IT.cd_vd
         INNER JOIN fp_func FUNC ON FUNC.cd_fun = IT.cd_vend
		 
		 INNER JOIN glb_cid CID ON func.cd_cid = cid.cd_cid
			LEFT JOIN glb_cid_glb_municipio CIDMUN ON CIDMUN.cd_cid = CID.cd_cid
			LEFT JOIN glb_municipio MUNICIPIO ON MUNICIPIO.cd_municipio = CIDMUN.cd_municipio
    WHERE 
		it.cd_emp=@cd_emp 
		and it.cd_filial = @Filial
		and vd.st_Vd=0
		and it.dt_vd =@data  
		and it.st_it=1

	UNION
	SELECT DISTINCT
           FUNC.cd_fun
         , FUNC.cd_filial
         , FUNC.cpf_fun AS cpf
         , FUNC.rg_fun AS rg
         , FUNC.nm_fun AS nome
         , FUNC.dt_nasc AS dataNascimento
         , COALESCE(MUNICIPIO.cod_municipio_sintegra, 0) AS codigoIbgeCidade 
		 , FUNC.end_fun AS enderecoLogradouro
         , '' AS enderecoNumero
         , FUNC.bairro_fun AS enderecoComplemento
         , FUNC.cep AS cep
         , FUNC.tel_res AS telefone
         , FUNC.tel_cel AS celular
         , FUNC.email AS email
         , 1 AS cargo
    FROM
         EST_NF_SAI S
         INNER JOIN fp_func FUNC ON FUNC.cd_fun = S.cd_vend		 
		 INNER JOIN glb_cid CID ON func.cd_cid = cid.cd_cid
			LEFT JOIN glb_cid_glb_municipio CIDMUN ON CIDMUN.cd_cid = CID.cd_cid
			LEFT JOIN glb_municipio MUNICIPIO ON MUNICIPIO.cd_municipio = CIDMUN.cd_municipio
    WHERE 
		S.cd_emp=@cd_emp 
		and S.cd_filial = @Filial
		and S.STS_NF=0
		and S.dt_EMI_NF =@data  	
	UNION
	SELECT DISTINCT
           FUNC.cd_fun
         , FUNC.cd_filial
         , FUNC.cpf_fun AS cpf
         , FUNC.rg_fun AS rg
         , FUNC.nm_fun AS nome
         , FUNC.dt_nasc AS dataNascimento
         , COALESCE(MUNICIPIO.cod_municipio_sintegra, 0) AS codigoIbgeCidade 
		 , FUNC.end_fun AS enderecoLogradouro
         , '' AS enderecoNumero
         , FUNC.bairro_fun AS enderecoComplemento
         , FUNC.cep AS cep
         , FUNC.tel_res AS telefone
         , FUNC.tel_cel AS celular
         , FUNC.email AS email
         , 1 AS cargo
    FROM
         fp_func FUNC
		 INNER JOIN glb_cid CID ON func.cd_cid = cid.cd_cid
			LEFT JOIN glb_cid_glb_municipio CIDMUN ON CIDMUN.cd_cid = CID.cd_cid
			LEFT JOIN glb_municipio MUNICIPIO ON MUNICIPIO.cd_municipio = CIDMUN.cd_municipio
    WHERE 
		FUNC.cd_emp=@cd_emp
		and FUNC.cd_fun = 1
		AND EXISTS (SELECT S.CD_EMP FROM
							 EST_NF_SAI S 
						WHERE 
							S.cd_emp=@cd_emp 
							and S.cd_filial = @Filial
							and S.STS_NF=0
							and S.dt_EMI_NF =@data  	)
) AS COLAB;